/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13; import lotus.domino.*; import djbuch.kapitel_06.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class CMSLoopSimple implements Runnable {

	private static final String PASSWORD = "geheim";
	private static final String HOST = "www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = "Thomas Ekert/DJBUCH";	//null fr lokale Session
	
	public static void main(String[] args) {
		CMSLoopSimple cmsLoop = new CMSLoopSimple ();
		NotesThread nt = new NotesThread ((Runnable) cmsLoop);
		nt.start();
	}
	
	public void run () {
		Session session = null; Database db = null;
		Document doc=null, nextDoc=null;
		View view=null; DocumentCollection dc=null;
		try {
			session=NotesFactory.createSession (HOST, USER, PASSWORD);
			db = session.getDatabase(session.getServerName(),"djbuch/djbuch.nsf");
			String key = "CMS Document Simple " + System.currentTimeMillis();			
			CMSDocumentSimple cmsDoc = new CMSDocumentSimple (DemoTools.createDoc(db,"CMS Simple",key,null));
			GC.recycle(cmsDoc.getDoc());
			cmsDoc=null;
			view = db.getView("V_lookup_k6");
			dc=view.getAllDocumentsByKey("CMS Document Simple ",false);
			doc=dc.getFirstDocument();
			while (doc!=null) {
				nextDoc = dc.getNextDocument(doc);
				cmsDoc=new CMSDocumentSimple(doc);
				cmsDoc.setActive(cmsDoc.isActive()?false:true);
				System.out.println (cmsDoc.getTitle() + " ist " + (cmsDoc.isActive()?"aktiv":"inaktiv"));
				cmsDoc.getDoc().save(true,false);
				GC.recycle(doc); //Achtung dies recycled einen Teil von cmsDoc
				doc=nextDoc;
			}
		} catch (NotesException e) {
			System.out.println ("id = " + (e instanceof NotesException?""+((NotesException)e).id:""));
			e.printStackTrace();
		} finally {
			GC.recycle(doc); GC.recycle(nextDoc); GC.recycle(dc); GC.recycle(view);
			GC.recycle(db); GC.recycle(session);
		}		
	}
}
